import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gap/gap.dart';
import 'package:razinsoft_rider/core/extensions/extensions.dart';
import 'package:razinsoft_rider/core/theme/color_palette.dart';
import 'package:razinsoft_rider/core/widgets/buttons/app_back_button.dart';
import 'package:razinsoft_rider/gen/assets.gen.dart';
import 'package:razinsoft_rider/presentation/account_page/provider/theme_provider.dart';
import 'package:razinsoft_rider/presentation/account_page/view/account_page.dart';

class AuthAppBar extends ConsumerWidget {
  const AuthAppBar(
      {super.key, this.showLeading = true, this.title, this.child});
  final bool showLeading;
  final String? title;
  final Widget? child;

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final bool isDarkMode = ref.watch(themeModeProvider) == ThemeMode.dark;
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor: isDarkMode ? ColorPalette.primary20 : ColorPalette.primary50,
        statusBarIconBrightness: Brightness.light,
        statusBarBrightness: Brightness.dark,
      ),
    );

    return Stack(
      clipBehavior: Clip.none,
      children: [
        Container(
          height: 180.h,
          width: double.infinity,
          padding: const EdgeInsets.all(16),
          decoration:  BoxDecoration(
            color: isDarkMode ? ColorPalette.primary20 : ColorPalette.primary50,
            borderRadius: const BorderRadius.only(
              bottomLeft: Radius.circular(16),
              bottomRight: Radius.circular(16),
            ),
          ),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
               Gap(40.h),
              showLeading
                  ? Row(
                      children: [
                        const AppBackButton(
                          color: ColorPalette.neutral100,
                        ),
                        SizedBox(width: 16.w),
                        Expanded(
                          child: Text(title ?? '',
                              textAlign: TextAlign.start,
                              maxLines: 1,
                              overflow: TextOverflow.ellipsis,
                              style: context.bodyMedium?.copyWith(fontSize: 16.sp, fontWeight: FontWeight.w500, color: Colors.white)),
                        ),
                        countrySelector(showDecoration: true)
                      ],
                    )
                  : Row(
                    children: [
                      Assets.images.rideIn.image(
                          height: 49.h,
                          width: 80.w,
                          fit: BoxFit.fill,
                        ),
                      const Spacer(),
                      countrySelector(showDecoration: true)
                    ],
                  ),

            ],
          ),
        ),
        Align(
          alignment: Alignment.topCenter,
          child: Padding(
            padding: EdgeInsets.only(
                top: showLeading ? 110.h : 125.h, left: 16.w, right: 16.w, bottom: 16.h),
            child: Material(
              elevation: 6,
              borderRadius: BorderRadius.circular(16),
              color: isDarkMode ? Colors.black : Colors.white,
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: 16.w, vertical: 24.h),
                decoration: BoxDecoration(
                  color: isDarkMode ? Colors.black : Colors.white,
                  borderRadius: BorderRadius.circular(16),
                ),
                child: SingleChildScrollView(
                  padding: EdgeInsets.only(
                    bottom: MediaQuery.of(context).viewInsets.bottom,
                  ),
                  child: child,
                ),
              ),
            ),
          ),
        ),
      ],
    );
  }
}
